/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerInfoWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerListWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.controls.CycleButton;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.AutoScaledStringWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6382;
import net.minecraft.class_7532;
import net.minecraft.class_7842;

public class PlayerInfoWidget
extends class_339 {
    public static final class_2960 TRAINER_CARD_IMAGE_LOCATION = class_2960.method_60655((String)"rctmod", (String)"textures/gui/trainer_card.png");
    public static final int TRAINER_CARD_IMAGE_X = 0;
    public static final int TRAINER_CARD_IMAGE_Y = 0;
    public static final int TRAINER_CARD_IMAGE_W = 224;
    public static final int TRAINER_CARD_IMAGE_H = 128;
    public static final int SKIN_X = 13;
    public static final int SKIN_Y = 32;
    public static final int SKIN_SIZE = 72;
    public static final int DISPLAY_NAME_X = 16;
    public static final int DISPLAY_NAME_Y = 8;
    public static final int DISPLAY_NAME_W = 66;
    public static final int DISPLAY_NAME_H = 16;
    public static final int LEVEL_CAP_X = 8;
    public static final int LEVEL_CAP_Y = 104;
    public static final int LEVEL_CAP_W = 82;
    public static final int LEVEL_CAP_H = 16;
    public static final int LEVEL_CAP_PADDING = 4;
    public static final int TOTAL_DEFEATS_X = 96;
    public static final int TOTAL_DEFEATS_Y = 104;
    public static final int TOTAL_DEFEATS_W = 88;
    public static final int TOTAL_DEFEATS_H = 16;
    public static final int TOTAL_DEFEATS_PADDING = 4;
    public static final int TRAINER_LIST_X = 96;
    public static final int TRAINER_LIST_Y = 32;
    public static final int TRAINER_LIST_W = 112;
    public static final int TRAINER_LIST_H = 72;
    public static final int TYPE_BUTTON_X = 96;
    public static final int TYPE_BUTTON_Y = 8;
    public static final int TYPE_BUTTON_W = 100;
    public static final int TYPE_BUTTON_H = 16;
    public static final int CHECKBOX_X = 196;
    public static final int CHECKBOX_Y = 8;
    public static final int CHECKBOX_W = 20;
    public static final int CHECKBOX_H = 16;
    public static final List<String> CHECKBOX_VALUES = List.of(" ", "\u2714");
    public static final int NEXT_PAGE_BUTTON_X = 200;
    public static final int NEXT_PAGE_BUTTON_Y = 104;
    public static final int NEXT_PAGE_BUTTON_SIZE = 16;
    static final TrainerType ALL_TRAINER_TYPES = new TrainerType("All");
    private class_7842 displayName;
    private class_7842 levelCapLabel;
    private class_7842 levelCapValue;
    private class_7842 totalDefeatsLabel;
    private class_7842 totalDefeatsValue;
    private TrainerListWidget trainerList;
    private TrainerInfoWidget trainerInfo;
    private CycleButton<TrainerType> trainerTypeButton;
    private class_4185 nextPageButton;
    private class_4185 prevPageButton;
    private CycleButton<String> showUndefeated;
    private class_339[] renderableWidgets;
    private class_339[] renderableOnlies;
    private Boolean trainerListShowUndefeated;
    private class_2561 trainerListType;
    private class_2960 skinLocation;
    private class_327 font;
    private List<TrainerType> trainerTypes;
    private String sid;

    public PlayerInfoWidget(int x, int y, int w, int h, class_327 font) {
        super(x, y, w, h, (class_2561)class_2561.method_43473());
        this.field_22763 = false;
        this.font = font;
        this.displayName = new AutoScaledStringWidget(x + 16, y + 8, 66, 16, (class_2561)class_2561.method_43473(), this.font).alignCenter().fitting(true);
        this.levelCapLabel = new class_7842(x + 8 + 4, y + 104 + 2, 82, 16, (class_2561)class_2561.method_43470((String)"Level Cap").method_27692(class_124.field_1068), this.font).method_48596();
        this.levelCapValue = new class_7842(x + 8, y + 104 + 2, 78, 16, (class_2561)class_2561.method_43473(), this.font).method_48599();
        this.totalDefeatsLabel = new class_7842(x + 96 + 4, y + 104 + 2, 88, 16, (class_2561)class_2561.method_43470((String)"Total").method_27692(class_124.field_1068), this.font).method_48596();
        this.totalDefeatsValue = new class_7842(x + 96, y + 104 + 2, 84, 16, (class_2561)class_2561.method_43473(), this.font).method_48599();
        this.trainerList = new TrainerListWidget(x + 96, y + 32, 112, 72, font, this.sortedTrainerIds());
        this.trainerInfo = new TrainerInfoWidget(x + 96, y + 32, 112, 72, font);
        this.trainerTypes = new ArrayList<TrainerType>();
        this.trainerTypes.add(ALL_TRAINER_TYPES);
        this.showUndefeated = CycleButton.create(t -> class_2561.method_43470((String)t), CHECKBOX_VALUES, 1, x + 196, y + 8, 20, 16, true);
        this.trainerTypeButton = CycleButton.create(t -> class_2561.method_43470((String)t.name()), this.trainerTypes, 0, x + 96, y + 8, 100, 16, false);
        this.nextPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), this::onNextPage).method_46433(x + 200, y + 104).method_46437(16, 16).method_46431();
        this.prevPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), this::onPrevPage).method_46433(x + 200 - 16, y + 104).method_46437(16, 16).method_46431();
        this.renderableWidgets = new class_339[]{this.trainerList, this.trainerInfo, this.trainerTypeButton, this.showUndefeated, this.prevPageButton, this.nextPageButton};
        this.renderableOnlies = new class_339[]{this.displayName, this.levelCapLabel, this.levelCapValue, this.totalDefeatsLabel, this.totalDefeatsValue};
        this.trainerList.setOnTrainerClicked((trainerNr, trainerId, entryState) -> {
            this.trainerInfo.initTrainerInfo(trainerNr, trainerId, entryState);
            this.trainerInfo.setPage(0);
            this.setDisplay(Display.TRAINER_INFO);
        });
        this.trainerInfo.setOnBackClicked(i -> this.setDisplay(Display.TRAINER_LIST));
        this.setDisplay(Display.TRAINER_LIST);
    }

    private void resetTrainerTypes() {
        this.trainerTypes.clear();
        this.trainerTypes.add(ALL_TRAINER_TYPES);
        this.trainerTypeButton.setValue(0);
        this.updateTrainerTypes(this.sid);
    }

    public class_339[] getRenderableWidgets() {
        return this.renderableWidgets;
    }

    public class_339[] getRenderableOnlies() {
        return this.renderableOnlies;
    }

    public void setDisplay(Display display) {
        switch (display.ordinal()) {
            case 0: {
                this.trainerInfo.field_22763 = false;
                this.trainerInfo.field_22764 = false;
                this.trainerList.field_22763 = true;
                this.trainerList.field_22764 = true;
                this.showUndefeated.field_22763 = true;
                this.trainerTypeButton.field_22763 = true;
                if (this.trainerListShowUndefeated != null) {
                    if (this.trainerListShowUndefeated.booleanValue() != this.isShowUndefeatedSelected()) {
                        this.showUndefeated.method_25306();
                    }
                    this.trainerListShowUndefeated = null;
                }
                if (this.trainerListType == null) break;
                this.trainerTypeButton.method_25355(this.trainerListType);
                this.trainerListType = null;
                break;
            }
            case 1: {
                if (this.trainerListShowUndefeated == null) {
                    this.trainerListShowUndefeated = this.isShowUndefeatedSelected();
                }
                if (this.trainerListType == null) {
                    this.trainerListType = this.trainerTypeButton.method_25369();
                }
                if (this.isShowUndefeatedSelected()) {
                    this.showUndefeated.method_25306();
                }
                this.trainerInfo.field_22763 = true;
                this.trainerInfo.field_22764 = true;
                this.trainerList.field_22763 = false;
                this.trainerList.field_22764 = false;
                this.showUndefeated.field_22763 = false;
                this.trainerTypeButton.field_22763 = false;
                this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
            }
        }
    }

    public void tick() {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        int levelCap = playerState.getLevelCap();
        String sid = playerState.getCurrentSeries();
        this.skinLocation = mc.field_1724.method_52814().comp_1626();
        this.displayName.method_25355((class_2561)class_2561.method_43470((String)mc.field_1724.method_5476().getString()).method_27692(class_124.field_1056).method_27692(class_124.field_1068));
        this.levelCapValue.method_25355((class_2561)(levelCap <= 100 ? class_2561.method_43470((String)String.valueOf(levelCap)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
        if (this.trainerList.field_22763 && sid != null) {
            long totalDefeats;
            if (this.sid == null || !sid.equals(this.sid)) {
                this.sid = sid;
                this.resetTrainerTypes();
                this.trainerList.setTrainerIds(this.sortedTrainerIds());
            }
            this.totalDefeatsValue.method_25355((class_2561)((totalDefeats = this.getTotalDefeats()) < 1000000L ? class_2561.method_43470((String)String.valueOf(totalDefeats)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"1000000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
            this.nextPageButton.field_22763 = this.trainerList.getPage() < this.trainerList.getMaxPage();
            this.prevPageButton.field_22763 = this.trainerList.getPage() > 0;
            int trainerTypeIndex = this.trainerTypeButton.getIndex();
            boolean showUndefeated = this.isShowUndefeatedSelected();
            boolean showAllTypes = trainerTypeIndex == 0;
            this.trainerList.setTrainerType(this.trainerTypeButton.getValue());
            this.trainerList.setShowAllTypes(showAllTypes);
            this.trainerList.setShowUndefeated(showUndefeated);
            this.trainerList.tick();
        } else if (this.trainerInfo.field_22763) {
            int defeats = this.getDefeats(this.trainerInfo.getTrainerId());
            this.totalDefeatsValue.method_25355((class_2561)(defeats < 1000000 ? class_2561.method_43470((String)String.valueOf(defeats)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"1000000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
            this.nextPageButton.field_22763 = this.trainerInfo.getPage() < this.trainerInfo.getMaxPage();
            this.prevPageButton.field_22763 = this.trainerInfo.getPage() > 0;
            this.trainerInfo.tick();
        }
    }

    private void updateTrainerTypes(String sid) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        Iterator it = sm.getGraph(sid).stream().iterator();
        LinkedList<TrainerType> open = new LinkedList<TrainerType>(TrainerType.values());
        while (it.hasNext() && !open.isEmpty()) {
            TrainerType tt = tm.getData(((SeriesManager.TrainerNode)it.next()).id()).getType();
            Iterator it2 = open.iterator();
            while (it2.hasNext()) {
                TrainerType t = (TrainerType)it2.next();
                if (!tt.equals(t)) continue;
                this.trainerTypeButton.addValue(t);
                it2.remove();
            }
        }
    }

    protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25302(TRAINER_CARD_IMAGE_LOCATION, this.method_46426(), this.method_46427(), 0, 0, 224, 128);
        if (this.skinLocation != null) {
            class_7532.method_44443((class_332)guiGraphics, (class_2960)this.skinLocation, (int)(this.method_46426() + 13), (int)(this.method_46427() + 32), (int)72);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private boolean isShowUndefeatedSelected() {
        return this.showUndefeated.getValue().equals(CHECKBOX_VALUES.get(1));
    }

    private void onNextPage(class_4185 button) {
        if (this.trainerList.field_22763) {
            this.trainerList.setPage(this.trainerList.getPage() + 1);
        }
        if (this.trainerInfo.field_22763) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() + 1);
            this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private void onPrevPage(class_4185 button) {
        if (this.trainerList.field_22763) {
            this.trainerList.setPage(this.trainerList.getPage() - 1);
        }
        if (this.trainerInfo.field_22763) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() - 1);
            this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private long getTotalDefeats() {
        if (!this.isShowUndefeatedSelected()) {
            return this.trainerList.getShowAllTypes() ? this.getDistinctDefeats() : this.getDistinctDefeats(this.trainerList.getTrainerType());
        }
        if (!this.trainerList.getShowAllTypes()) {
            return this.getTotalDefeats(this.trainerList.getTrainerType());
        }
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        return playerState.getTrainerDefeatCount();
    }

    private long getTotalDefeats(TrainerType type) {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        return playerState.getTypeDefeatCount(type);
    }

    private long getDistinctDefeats() {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        int count = 0;
        for (TrainerType t : TrainerType.values()) {
            count = (int)((long)count + playerState.getTypeDefeatCount(t, true));
        }
        return count;
    }

    private long getDistinctDefeats(TrainerType type) {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        return playerState.getTypeDefeatCount(type, true);
    }

    private int getDefeats(String trainerId) {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        return playerState.getTrainerDefeatCount(trainerId);
    }

    private List<String> sortedTrainerIds() {
        class_310 mc = class_310.method_1551();
        PlayerState playerState = PlayerState.get((class_1657)mc.field_1724);
        TrainerManager tdm = RCTMod.getInstance().getTrainerManager();
        return tdm.getAllData(playerState.getCurrentSeries()).map(entry -> (String)entry.getKey()).sorted((k1, k2) -> {
            TrainerMobData t1 = tdm.getData((String)k1);
            TrainerMobData t2 = tdm.getData((String)k2);
            int c = t1.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) - t2.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0);
            if (c == 0 && (c = t1.getTrainerTeam().getName().compareTo(t2.getTrainerTeam().getName())) == 0) {
                c = k1.compareTo((String)k2);
            }
            return c;
        }).toList();
    }

    public static enum Display {
        TRAINER_LIST,
        TRAINER_INFO;

    }
}

